/**
 * API Handler for Contact Form Submissions
 * Sends form data to the backend endpoint
 */

const API_CONFIG = {
  endpoint: "https://kp.alnairtech.com/enquiry.php",
  timeout: 10000, // 10 seconds
};

/**
 * Submit enquiry form data to the API
 * @param {Object} formData - The form data object
 * @returns {Promise<Object>} - Response from the API
 */
async function submitEnquiry(formData) {
  try {
    // Create FormData object for sending
    const data = new FormData();
    data.append("first_name", formData.firstName);
    data.append("last_name", formData.lastName);
    data.append("email", formData.email);
    data.append("phone_number", formData.phone);
    data.append("post_code", formData.postcode);
    data.append("service_type", formData.serviceType);
    data.append("project_detail", formData.projectDetails);

    // Make the API request
    const response = await fetch(API_CONFIG.endpoint, {
      method: "POST",
      body: data,
      headers: {
        Accept: "application/json",
      },
    });

    // Check if response is ok
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    // Parse JSON response
    const result = await response.json();

    return {
      success: true,
      data: result,
    };
  } catch (error) {
    console.error("API Error:", error);

    return {
      success: false,
      error: error.message || "Failed to submit enquiry. Please try again.",
    };
  }
}
